/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.server.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.sonarlint.eclipse.core.internal.jobs.ServerUpdateJob;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.ui.internal.Messages;
import org.sonarlint.eclipse.ui.internal.SonarLintImages;

public class ServerUpdateAction
extends SelectionProviderAction {
    private List<IServer> servers;

    public ServerUpdateAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.actionUpdate);
        this.setImageDescriptor(SonarLintImages.UPDATE_IMG);
    }

    public void selectionChanged(IStructuredSelection sel) {
        if (sel.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        this.servers = new ArrayList<IServer>();
        boolean enabled = false;
        for (Object obj : sel) {
            if (obj instanceof IServer) {
                IServer server = (IServer)obj;
                this.servers.add(server);
                enabled = true;
                continue;
            }
            this.setEnabled(false);
            return;
        }
        this.setEnabled(enabled);
    }

    public void run() {
        IStructuredSelection sel;
        if (this.servers == null && (sel = this.getStructuredSelection()) != null) {
            this.selectionChanged(sel);
        }
        if (this.servers != null) {
            for (IServer server : this.servers) {
                ServerUpdateJob j = new ServerUpdateJob(server);
                j.schedule();
            }
        }
    }
}

